<?php
require_once 'security.php';
require_once 'db.php';
if (!isset($_SESSION['user_id'])) { header("Location: index.php"); exit(); }
$user_id = $_SESSION['user_id'];

// Pagination
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = 20;
$offset = ($page - 1) * $limit;

$total = $conn->query("SELECT COUNT(*) FROM transactions WHERE user_id = $user_id")->fetch_row()[0];
$pages = ceil($total / $limit);

$stmt = $conn->prepare("SELECT * FROM transactions WHERE user_id = ? ORDER BY created_at DESC LIMIT ? OFFSET ?");
$stmt->bind_param("iii", $user_id, $limit, $offset);
$stmt->execute();
$res = $stmt->get_result();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transactions</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Poppins', sans-serif; background: #f8fafc; padding: 20px; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 20px; border-radius: 12px; }
        .header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
        table { width: 100%; border-collapse: collapse; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #eee; font-size: 0.9rem; }
        .badge { padding: 4px 8px; border-radius: 4px; font-size: 0.8rem; }
        .success { background: #dcfce7; color: #166534; }
        .failed { background: #fee2e2; color: #991b1b; }
        .btn { padding: 8px 15px; background: #2563eb; color: white; text-decoration: none; border-radius: 5px; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>Transaction History</h2>
            <a href="dashboard.php" class="btn">Back to Dashboard</a>
        </div>
        <table>
            <thead><tr><th>Date</th><th>Service</th><th>Amount</th><th>Status</th></tr></thead>
            <tbody>
                <?php while($row = $res->fetch_assoc()): ?>
                <tr>
                    <td><?php echo date('d M Y, H:i', strtotime($row['created_at'])); ?></td>
                    <td><?php echo ucfirst($row['transaction_type']); ?> <br> <small><?php echo $row['description']; ?></small></td>
                    <td>₦<?php echo number_format($row['amount'], 2); ?></td>
                    <td><span class="badge <?php echo $row['status']=='success'?'success':'failed'; ?>"><?php echo ucfirst($row['status']); ?></span></td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
        
        <div style="margin-top:20px; display:flex; gap:10px;">
            <?php if($page > 1): ?><a href="?page=<?php echo $page-1; ?>" class="btn">Previous</a><?php endif; ?>
            <?php if($page < $pages): ?><a href="?page=<?php echo $page+1; ?>" class="btn">Next</a><?php endif; ?>
        </div>
    </div>
</body>
</html>