<?php 
require_once 'verify_jwt.php';
include 'db.php';

header('Content-Type: application/json');

$user_id = $_GET['user_id'] ?? '';

if ($user_id === '') {
    echo json_encode(['status' => false, 'message' => 'Missing user_id']);
    exit;
}

// Fetch only OPAY account
$query = "SELECT account_number, account_name, bank_name, bank_id 
          FROM virtual_accounts 
          WHERE user_id = ? AND UPPER(bank_id) = 'OPAY'";

$stmt = $conn->prepare($query);
$stmt->bind_param('s', $user_id);
$stmt->execute();
$result = $stmt->get_result();

$accounts = [];
while ($row = $result->fetch_assoc()) {
    // Remove " (Paymentpoint)" suffix from account name
    $cleanedName = preg_replace('/\s*\(Paymentpoint\)$/i', '', $row['account_name']);

    $accounts[] = [
        'account_number' => $row['account_number'],
        'account_name'   => $cleanedName,
        'bank_name'      => $row['bank_name'],
        'bank_id'        => $row['bank_id']
    ];
}

if (!empty($accounts)) {
    echo json_encode([
        'status' => true,
        'data' => $accounts
    ]);
} else {
    echo json_encode(['status' => false, 'message' => 'No OPay virtual account found']);
}
?>