<?php
// check_plans.php - Fetch LIVE Data Plans from Alummadata
error_reporting(E_ALL);
ini_set('display_errors', 1);

// ⚠️ PASTE YOUR API KEY HERE
$api_key = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJ1c2UiOiJhcGkiLCJpZCI6OTUzOSwiZHNpIjoiNjE0OTI2NTY5ODkyNzY3MzIxNzgiLCJpYXQiOjE3NjY0MDYxNTYsImV4cCI6MjA1MDMzNDM3NSwiaXNzIjoiQWx1bW1hZGF0YSJ9.I7erBrI1IPirqSHnuHqIjgIeOMhg7EGNhW2ZX6D_soU"; 

$curl = curl_init();
curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://api.alummadata.com.ng/api/v2/services/data', // Try this endpoint first
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    "Authorization: Bearer $api_key",
    "Content-Type: application/json"
  ),
));

$response = curl_exec($curl);
curl_close($curl);

$data = json_decode($response, true);

echo "<h1>📡 Live Data Plan List</h1>";
echo "<p>Use these IDs in your dashboard.php file.</p>";

if (isset($data['data'])) {
    echo "<table border='1' cellpadding='10' style='border-collapse:collapse;'>";
    echo "<tr style='background:#eee;'><th>Network</th><th>Plan Name</th><th>Plan ID (Use This)</th><th>Price</th></tr>";
    
    foreach ($data['data'] as $plan) {
        echo "<tr>";
        echo "<td>" . ($plan['network'] ?? 'N/A') . "</td>";
        echo "<td>" . ($plan['name'] ?? 'N/A') . " " . ($plan['size'] ?? '') . "</td>";
        echo "<td style='font-weight:bold; color:red;'>" . ($plan['id'] ?? $plan['plan_id']) . "</td>";
        echo "<td>₦" . ($plan['amount'] ?? '0') . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<h3>Failed to fetch plans. Raw Response:</h3>";
    echo "<pre>"; print_r($data); echo "</pre>";
}
?>