<?php
// FILE: public_html/Nag/settings.php
session_start();
require_once '../db.php';

// 1. Security Check: Ensure only Admin can access
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

// Optional: Double check admin role from DB for extra security
$uid = $_SESSION['user_id'];
$chk = $conn->query("SELECT role FROM users WHERE id = $uid");
if ($chk->num_rows == 0 || $chk->fetch_assoc()['role'] !== 'admin') {
    die("Access Denied.");
}

$msg = "";

// 2. Handle Form Submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Sanitize Inputs
    $bank_name = $conn->real_escape_string($_POST['bank_name']);
    $account_name = $conn->real_escape_string($_POST['account_name']);
    $account_no = $conn->real_escape_string($_POST['account_no']);
    $support_phone = $conn->real_escape_string($_POST['support_phone']);
    
    // Ensure table exists
    $conn->query("CREATE TABLE IF NOT EXISTS settings (
        id INT AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(50) UNIQUE,
        value TEXT
    )");

    // Helper function using ON DUPLICATE KEY UPDATE (More efficient)
    function save_setting($conn, $name, $value) {
        $sql = "INSERT INTO settings (name, value) VALUES ('$name', '$value') 
                ON DUPLICATE KEY UPDATE value = '$value'";
        $conn->query($sql);
    }

    save_setting($conn, 'bank_name', $bank_name);
    save_setting($conn, 'account_name', $account_name);
    save_setting($conn, 'account_no', $account_no);
    save_setting($conn, 'support_phone', $support_phone);
    
    $msg = "✅ Settings saved successfully!";
}

// 3. Fetch Current Settings
$settings = [];
$res = $conn->query("SELECT * FROM settings");
if ($res) {
    while($row = $res->fetch_assoc()) {
        $settings[$row['name']] = $row['value'];
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>General Settings - Nagarta Data</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Poppins', sans-serif; padding: 20px; background: #f4f7f6; color: #333; }
        .card { background: white; padding: 40px; max-width: 600px; border-radius: 15px; margin: 20px auto; box-shadow: 0 10px 25px rgba(0,0,0,0.05); }
        h2 { text-align: center; color: #2c3e50; margin-bottom: 30px; }
        h3 { font-size: 1.1rem; color: #10b981; margin-top: 0; }
        
        input { 
            width: 100%; padding: 12px; margin: 8px 0 20px 0; 
            border: 1px solid #ddd; border-radius: 8px; box-sizing: border-box; 
            font-family: inherit;
        }
        input:focus { border-color: #10b981; outline: none; }
        
        label { font-weight: 600; font-size: 0.9rem; color: #555; }
        
        button { 
            background: #2c5364; color: white; border: none; 
            padding: 15px; border-radius: 8px; cursor: pointer; 
            width: 100%; font-size: 1rem; font-weight: bold; 
            transition: 0.3s; 
        }
        button:hover { background: #203a43; }
        
        .alert { 
            background: #d1fae5; color: #065f46; padding: 15px; 
            border-radius: 8px; text-align: center; margin-bottom: 20px; 
            border: 1px solid #a7f3d0;
        }
        .back-link { 
            display: block; text-align: center; margin-bottom: 20px; 
            text-decoration: none; color: #666; font-size: 0.9rem; 
        }
        .back-link:hover { color: #10b981; }
        
        .section-desc { font-size: 0.85rem; color: #888; margin-bottom: 15px; margin-top: -5px; }
    </style>
</head>
<body>

    <div class="card">
        <a href="dashboard.php" class="back-link">&larr; Back to Dashboard</a>
        <h2>App Settings</h2>
        
        <?php if($msg) echo "<div class='alert'>$msg</div>"; ?>
        
        <form method="POST">
            <h3>🏦 Manual Bank Transfer</h3>
            <p class="section-desc">Details shown to users when they choose "Bank Transfer" funding.</p>
            
            <label>Bank Name</label>
            <input type="text" name="bank_name" value="<?php echo htmlspecialchars($settings['bank_name'] ?? ''); ?>" placeholder="e.g. GTBank">

            <label>Account Name</label>
            <input type="text" name="account_name" value="<?php echo htmlspecialchars($settings['account_name'] ?? ''); ?>" placeholder="e.g. Nagarta Data Ltd">

            <label>Account Number</label>
            <input type="text" name="account_no" value="<?php echo htmlspecialchars($settings['account_no'] ?? ''); ?>" placeholder="e.g. 0123456789">

            <hr style="margin: 30px 0; border: 0; border-top: 1px solid #f0f0f0;">

            <h3>📞 Support Contact</h3>
            <p class="section-desc">Phone number for WhatsApp/Call support button.</p>
            
            <label>Support Phone</label>
            <input type="text" name="support_phone" value="<?php echo htmlspecialchars($settings['support_phone'] ?? ''); ?>" placeholder="e.g. 08012345678">

            <button type="submit">Save Changes</button>
        </form>
    </div>

</body>
</html>