<?php
session_start();
include '../db.php';
if (!isset($_SESSION['admin_logged_in'])) { header("Location: index.php"); exit(); }

$id = $_GET['id'];
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $phone = $_POST['phone'];
    $vip = $_POST['vip'];
    
    // Optional: Reset Password
    if (!empty($_POST['new_pass'])) {
        $pass = password_hash($_POST['new_pass'], PASSWORD_BCRYPT);
        $conn->query("UPDATE users SET password = '$pass' WHERE id = $id");
        $msg = "Password reset! ";
    }

    $stmt = $conn->prepare("UPDATE users SET phone = ?, vip = ? WHERE id = ?");
    $stmt->bind_param("sii", $phone, $vip, $id);
    $stmt->execute();
    $msg .= "User details updated!";
}

$user = $conn->query("SELECT * FROM users WHERE id = $id")->fetch_assoc();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Edit User</title>
    <style>
        body { font-family: sans-serif; display: flex; justify-content: center; padding-top: 50px; background: #f1f5f9; }
        .box { background: white; padding: 30px; width: 400px; border-radius: 8px; box-shadow: 0 4px 10px rgba(0,0,0,0.1); }
        input, select { width: 100%; padding: 10px; margin: 10px 0; border: 1px solid #ddd; box-sizing: border-box; }
        button { width: 100%; padding: 10px; background: #3b82f6; color: white; border: none; border-radius: 4px; cursor: pointer; }
    </style>
</head>
<body>
    <div class="box">
        <h2>Edit User: <?php echo $user['username']; ?></h2>
        <?php if(isset($msg)) echo "<p style='color:green'>$msg</p>"; ?>
        
        <form method="POST">
            <label>Phone Number</label>
            <input type="text" name="phone" value="<?php echo $user['phone']; ?>">

            <label>VIP Status (1 = VIP, 0 = Normal)</label>
            <select name="vip">
                <option value="0" <?php if($user['vip'] == 0) echo 'selected'; ?>>Normal User</option>
                <option value="1" <?php if($user['vip'] == 1) echo 'selected'; ?>>VIP User</option>
            </select>

            <label>Reset Password (Leave empty to keep current)</label>
            <input type="text" name="new_pass" placeholder="Enter new password">

            <button type="submit">Save Changes</button>
        </form>
        <br>
        <a href="users.php" style="text-decoration: none; color: #666;">&larr; Back to Users</a>
    </div>
</body>
</html>