<?php
session_start();
include '../db.php';
if (!isset($_SESSION['admin_logged_in'])) { header("Location: index.php"); exit(); }

// Update Plan Price or Switch Status
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = $_POST['id'];
    $price = $_POST['price'];
    $status = $_POST['status']; // 1 = Active, 0 = Inactive
    
    $stmt = $conn->prepare("UPDATE data_plans SET price = ?, switch = ? WHERE id = ?");
    $stmt->bind_param("dii", $price, $status, $id);
    $stmt->execute();
    $msg = "Plan updated successfully!";
}

$plans = $conn->query("SELECT * FROM data_plans ORDER BY network ASC, price ASC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Manage Data Plans</title>
    <style>
        body { font-family: sans-serif; padding: 20px; background: #f1f5f9; }
        .card { background: white; padding: 20px; border-radius: 8px; margin-bottom: 20px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        table { width: 100%; border-collapse: collapse; }
        td, th { padding: 12px; border-bottom: 1px solid #eee; text-align: left; }
        input[type="number"] { width: 80px; padding: 5px; }
        button { background: #10b981; color: white; border: none; padding: 5px 10px; border-radius: 4px; cursor: pointer; }
        select { padding: 5px; }
    </style>
</head>
<body>
    <h2>Data Plan Management</h2>
    <a href="dashboard.php">Back to Dashboard</a>
    <?php if(isset($msg)) echo "<p style='color:green'>$msg</p>"; ?>

    <div class="card">
        <table>
            <thead>
                <tr>
                    <th>Network</th>
                    <th>Plan Name</th>
                    <th>Plan ID</th>
                    <th>Current Price (₦)</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php while($row = $plans->fetch_assoc()): ?>
                <form method="POST">
                <tr>
                    <td><b><?php echo $row['network']; ?></b></td>
                    <td><?php echo $row['quantity'] . ' ' . $row['validity']; ?></td>
                    <td><small><?php echo $row['plan_id']; ?></small></td>
                    <td>
                        <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
                        <input type="number" name="price" value="<?php echo $row['price']; ?>" step="0.01">
                    </td>
                    <td>
                        <select name="status">
                            <option value="1" <?php if($row['switch'] == 1) echo 'selected'; ?>>Active</option>
                            <option value="0" <?php if($row['switch'] == 0) echo 'selected'; ?>>Disabled</option>
                        </select>
                    </td>
                    <td><button type="submit">Update</button></td>
                </tr>
                </form>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</body>
</html>