<?php
session_start();
// Security Check
if (!isset($_SESSION['admin_logged_in'])) { header("Location: index.php"); exit(); }

// --- FUNCTION TO CHECK BALANCE (Generic) ---
function get_vendor_balance($url, $token) {
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
            'Authorization: Token ' . $token, // Most vendors use "Token" or "Bearer"
            'Content-Type: application/json'
        ),
    ));

    $response = curl_exec($curl);
    $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    curl_close($curl);

    if ($httpcode == 200) {
        $data = json_decode($response, true);
        // ADJUST THIS based on vendor response. Usually it is $data['user']['wallet_balance']
        return $data['user']['wallet_balance'] ?? $data['balance'] ?? '0.00';
    } else {
        return "Error";
    }
}

// --- DEFINE VENDORS ---
// You will replace these with your ACTUAL keys later
$vendors = [
    [
        'name' => 'Alummadata',
        'url' => 'https://alummadata.com/api/user/', 
        'key' => 'REPLACE_WITH_ACTUAL_ALUMMA_KEY' 
    ],
    [
        'name' => 'DataStation',
        'url' => 'https://datastation.com/api/user/',
        'key' => 'REPLACE_WITH_ACTUAL_DATASTATION_KEY'
    ],
    // Add 9mobile, Cable, or Electricity vendors here
];

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>API Status & Balances</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #1e293b; --accent: #10b981; --light: #f1f5f9; --white: #ffffff; }
        body { font-family: 'Segoe UI', sans-serif; background: var(--light); margin: 0; display: flex; }
        
        /* Sidebar (Same as dashboard) */
        .sidebar { width: 250px; background: var(--primary); color: var(--white); height: 100vh; position: fixed; padding: 20px 0; }
        .sidebar h2 { text-align: center; margin-bottom: 30px; font-size: 1.5rem; }
        .nav-link { display: block; padding: 15px 25px; color: #cbd5e1; text-decoration: none; transition: 0.3s; }
        .nav-link:hover { background: rgba(255,255,255,0.1); color: var(--accent); border-left: 4px solid var(--accent); }
        .nav-link i { margin-right: 10px; width: 20px; text-align: center; }

        /* Main Content */
        .main { margin-left: 250px; padding: 30px; width: 100%; }
        
        /* Balance Cards */
        .balance-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px; margin-top: 20px; }
        .vendor-card { background: white; padding: 25px; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.05); border-left: 5px solid var(--primary); }
        .vendor-card h3 { margin: 0 0 10px 0; color: #64748b; font-size: 1rem; text-transform: uppercase; }
        .vendor-balance { font-size: 2rem; font-weight: bold; color: var(--primary); }
        .low-balance { color: #dc2626; } /* Red color if low */
        .status-badge { display: inline-block; padding: 5px 10px; background: #dcfce7; color: #16a34a; border-radius: 15px; font-size: 0.8rem; margin-top: 10px; }
    </style>
</head>
<body>

    <div class="sidebar">
        <h2>Nagarta Admin</h2>
        <a href="dashboard.php" class="nav-link"><i class="fas fa-home"></i> Dashboard</a>
        <a href="users.php" class="nav-link"><i class="fas fa-users"></i> Users</a>
        <a href="data_plans.php" class="nav-link"><i class="fas fa-wifi"></i> Data Plans</a>
        <a href="api_status.php" class="nav-link" style="background: rgba(255,255,255,0.1); color: var(--accent); border-left: 4px solid var(--accent);"><i class="fas fa-server"></i> API Status</a>
        <a href="transactions.php" class="nav-link"><i class="fas fa-history"></i> Transactions</a>
        <a href="settings.php" class="nav-link"><i class="fas fa-cog"></i> Settings</a>
        <a href="../logout.php" class="nav-link"><i class="fas fa-sign-out-alt"></i> Logout</a>
    </div>

    <div class="main">
        <h1>Vendor API Balances</h1>
        <p>Monitor your wallet balance on external vendor platforms.</p>

        <div class="balance-grid">
            <?php foreach($vendors as $vendor): ?>
                <?php 
                    // Fetch real balance (Commented out until you have keys)
                    // $balance = get_vendor_balance($vendor['url'], $vendor['key']); 
                    
                    // SIMULATED BALANCE FOR NOW
                    $balance = "5,000.00"; 
                ?>
                
                <div class="vendor-card">
                    <h3><?php echo $vendor['name']; ?> Wallet</h3>
                    <div class="vendor-balance <?php echo ($balance < 1000) ? 'low-balance' : ''; ?>">
                        ₦<?php echo $balance; ?>
                    </div>
                    <?php if($balance != "Error"): ?>
                        <div class="status-badge"><i class="fas fa-check-circle"></i> Connected</div>
                    <?php else: ?>
                        <div class="status-badge" style="background:#fee2e2; color:#dc2626;"><i class="fas fa-times-circle"></i> Error</div>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
    </div>

</body>
</html>